--The function is changed to use a temporary table.  The temporary table is created before creating the function. SIR 1676. - GT

SPOOL f_fieldset.log
set echo on

drop table fieldset_temp_new;
create table fieldset_temp_new
tablespace storetdata
storage (initial 10M next 5M)
pctfree 1 nologging as
	SELECT translate(FDSET.NAME,chr(10),chr(182)) NAME, 
               TSRFDACT_IS_NUMBER, TSRFDACT_ORG_ID
	FROM storet1.TSRFAFSA FAFSA,
	     storet1.TSRFDSET FDSET
	WHERE FAFSA.TSRFDSET_IS_NUMBER = FDSET.TSRFDSET_IS_NUMBER
		AND   FAFSA.TSRFDSET_ORG_ID    = FDSET.TSRFDSET_org_id;
COMMIT;

create index ifieldset_temp_new_01 on fieldset_temp_new(TSRFDACT_IS_NUMBER, TSRFDACT_ORG_ID)
tablespace storetindx
storage(initial 4M next 4M)
nologging;

analyze table fieldset_temp_new compute statistics;
analyze index ifieldset_temp_new_01 compute statistics;


--rewrote the cursor definition to use fieldset_temp_new table.

create or replace FUNCTION F_FIELDSET (FDACT_IS_NUMBER IN NUMBER,
                                 FDACT_ORG_ID IN varCHAR2) RETURN VARCHAR2 AS
V_FIELDSET 	VARCHAR2(130):= NULL;
I 		NUMBER:=0;
CURSOR C1 IS
	SELECT NAME fieldset
	FROM fieldset_temp_new
	WHERE TSRFDACT_IS_NUMBER = FDACT_IS_NUMBER
		AND   TSRFDACT_ORG_ID = FDACT_ORG_ID;
BEGIN
FOR C1_VAR IN C1 LOOP
  if (i = 0 and i < 4) then
    V_FIELDSET:=c1_var.fieldset;
    i:=i+1;
  elsif (i > 0 and i < 4 ) then
    V_FIELDSET:=V_FIELDSET||'; '||c1_var.fieldset;
    i:=i+1;
  else
    i:=i+1;
  end if;
END LOOP;
  if V_FIELDSET is not null then
    return V_FIELDSET;
  else
    --return 'No Lab Remarks Found';
	return NULL;
  end if;
END;
/
show errors;

spool off;